;/*************************************************
; Program		:Test Real Time Clock
; Description	:use the PCF8583 is RTC, then it's value
;				:'ll be send to display on monitor via serial port. 
; CPU Control	:90S8535 
; File name		:pcf8583.asm
; Assembler		:AVR Studio 4.05
; 
;**************************************************

.include "8535def.inc"

			.org   	$000 
    		rjmp  reset			;Reset Handle
;/************************
; Define Register
;/************************
.def		counter1  	= r16
.def		counter2	= r17
.def		counter3	= r18
.def		temp		= r19
.def		data		= r21
.def		adress		= r23
;/***********************
; Define I/O Port,Pin
;/***********************
.equ		SCL		= 0
.equ		SDA		= 1
.equ		BUF_IN		= $60
.equ		BUF_OUT		= $70
.equ 		RTC_ADRW	= 0xA2		;address write
.equ		RTC_ADRR	= 0xA3  	;address read
;/*******************
; Main Program
;/*******************
reset:      ldi	temp,low(RAMEND)
            out	SPL,temp          	;init Stack Pointer     
            ldi	temp,high(RAMEND)
            out	SPH,temp        	
main:		sbi	UCR,TXEN
			ldi	temp,51
			out	UBRR,temp

PCF8583:	ldi	ZH,high(2*PCF8583TB)
			ldi	ZL,low(2*PCF8583TB)
			rcall	Intro
;/*****************************************
; read time from pcf 8583 at address 2 - 4
;/*****************************************
			ser	temp
			out	DDRC,temp
Loop_RTC:	ldi	XH,high(BUF_IN)
			ldi	XL,low(BUF_IN)
			ldi	adress,2
			rcall	Read
			ldi	adress,3
			rcall	Read
			ldi	adress,4
			rcall	Read		
			rcall	ASC
			rcall	ASCho			
			rcall	Display_Time
			rjmp	Loop_RTC

;/*********************************
; Write address and read data
;**********************************
Read:		rcall	I2C_Start
			ldi	data,RTC_ADRW		;MSB 7 bit address  + WR bit
			rcall	out
			mov	data,adress
			rcall	out
			rcall	I2C_Start
			ldi	data,RTC_ADRR		;set hold last count flag
			rcall	out
			rcall	in				;get data from second counter
			st	X+,data
			rcall	I2C_Stop
			ret

;/******************************
; display second:minute:hour
;/******************************
Display_Time:	
			ldi	YH,high(BUF_OUT)
			ldi	YL,low(BUF_OUT)
			rcall	TX_Time			;send Hours
			ldi	data,':'
			rcall	TX_Byte
			rcall	TX_Time			;send Minutes
			ldi	data,':'
			rcall	TX_Byte
			rcall	TX_Time			;send seconds
			rcall	delay200ms
			ldi	data,0x0d
			rcall	TX_Byte
			ret
TX_Time:	ld	data,Y+
			rcall	TX_Byte
			ld	data,Y+
			rcall	TX_Byte
			ret

ASC:		ldi	YH,high(BUF_OUT)	;Buffer out	
			ldi	YL,low(BUF_OUT)
			ldi	XH,high(BUF_IN)		;Buffer in
			ldi	XL,low(BUF_IN)
			ldi	counter1,2			;convert BCD 3 byte to ASCII Code
ASC1:		ld	data,X+
			mov	temp,data
			andi	data,0xF0		;mask LSB 4 bit  
			swap	data
			subi	data,-48		;data = data + 48	
			st	Y+,data		 
			mov	data,temp
			andi	data,0x0F
			subi	data,-48
			st	Y+,data
			dec	counter1
			brne	ASC1
			ret

ASCho:		ld	data,X
			mov	temp,data
			andi	data,0x30		;mask LSB 4 bit  
			swap	data
			subi	data,-48		;data = data + 48	
			st	Y+,data		 
			mov	data,temp
			andi	data,0x0F
			subi	data,-48
			st	Y+,data
			ret

;/****************
; I2C start pulse 
;/****************
I2C_Start:	sbi	PORTC,SDA
			sbi	PORTC,SCL
			rcall	I2C_delay
			cbi	PORTC,SDA
			rcall	I2C_delay
			cbi	PORTC,SCL
			ret
I2C_Stop:	cbi	PORTC,SDA
			rcall	I2C_delay
			sbi	PORTC,SCL
			rcall	I2C_delay
			sbi	PORTC,SDA
			ret
;/*******************************
; write data 8 bits
;/*******************************
out:		push	data
			ldi	counter1,8			;8 bit  data
out1:		sbi	PORTC,SDA		 
			rol	data
			brcs	out2			;if c flag=1 set SDA line else clear SDA line
			cbi	PORTC,SDA
out2:		nop
			sbi	PORTC,SCL
			rcall	I2C_delay
			cbi	PORTC,SCL
			rcall	I2C_delay
			dec	counter1
			brne	out1
			sbi	PORTC,SDA
			nop
			sbi	PORTC,SCL
			rcall	I2C_delay
			sbic	PINC,SDA		;if SDA line=1,begin write old data again
			rjmp	out3
			cbi	PORTC,SCL
			pop	data
			ret
out3:		pop	data
			rjmp	out

;/********************************
; receive data from SDA line
;/******************************** 
in:			push	counter1
			ldi	counter1,8				;8 bit data
			sbi	PORTC,SDA				;set SDA line for receiving new data
in1:		nop
			sbi	PORTC,SCL
			sec
			sbis	PINC,SDA			;set c flag when SDA line = 1
			clc
			rol	data					;rotate left
			cbi	PORTC,SCL
			rcall	I2C_delay
			dec	counter1
			brne	in1			
			sbi	PORTC,SDA				;send Acknowledge bit
			nop
			sbi	PORTC,SCL
			rcall	I2C_delay
			cbi	PORTC,SCL
			pop	counter1
			ret

;/********************
; Send text
;/********************
Intro:		lpm
			tst	r0
			breq	end_sub
TX232:		sbis	USR,UDRE
			rjmp	TX232
			out	UDR,r0
			adiw	ZL,1
			rjmp	Intro
end_sub:	ret		

;/******************
; Send a byte
;/******************

TX_Byte:	sbis	USR,UDRE
			rjmp	TX_Byte
			out	UDR,data
			ret
;/*****************
; delay time
;/*****************
I2C_delay:	push	counter1
			ldi    	counter1,5
I2C_delay_1: 	
			dec    	counter1
            brne   	I2C_delay_1
			pop	counter1
			ret

delay1ms:	push	counter1
			push	counter2
			ldi	counter1,8
delay1ms_1: ldi counter2,250
delay1ms_2: nop
			dec counter2
            brne   	delay1ms_2
            dec    	counter1
            brne   	delay1ms_1
            pop	counter2
			pop	counter1
			ret          

delay200ms:	push	counter3
			ldi	counter3,200
delay200ms_1:	
			rcall	delay1ms
			dec	counter3
			brne	delay200ms_1
			pop	counter3
			ret

;/******************
; code segment
;/******************

PCF8583TB:	.db	"Test Real Time Clock with PCF8583",0x0a,0x0d,0
           	 